;loads G3PLX bootstrap code into FLASH ROM
;**************************************************************************

; steps to write FLASH ROM with G3PLX bootstrap loader
; 1. load PLXBOOT.CLD into EVM using EVM56K debugger
; 2. enter GO at the command prompt
; 3. wait a few secs for the programming to complete and prompt returns
; 4. The EVM can now load/run .CLD files through the user port by using
;    the LOADEVM program, and .EXE programs specially written to work with
;    PLXBOOT can load/run the .CLD files without the use of the debugger
;    by using the boot option.
;**************************************************************************

;
;   3 Nov. 1994 : version 1.0   rlr/ljd
;  13 Apr. 1995 :         1.1   rlr - force write to low byte (enable_prot)
;  25 Oct. 1995 :         1.2   rlr - correct conversion to sector count
;  29 Mar. 1996 :         1.3   mnw - added user discription
;  06 Feb. 1997 :         1.4   wtb - added comments from Johan Forrer
;
;   copyright (C) Motorola 1994
;
BCR             equ     $FFFE           ;Bus Control Register
PLL_CTRL        equ     $FFFD           ;PLL Control Register

        org     p:$40

main
;---------------------------------------------------------------------------
;  An external boot-ROM must have the lowest byte of data at the lowest
;  address.  (i.e.,  ROM Address $C000 --- P:0000 low    byte
;                    ROM Address $C001 --- P:0000 middle byte
;                    ROM Address $C002 --- P:0000 high   byte
;                    ROM Address $C003 --- P:0001 low    byte ....)
;---------------------------------------------------------------------------

        movep   #$261009,x:PLL_CTRL     ;set PLL for MF=10, 40 MHz VCO out
        movep   #$B0B0,x:BCR            ;at 40MHz, T=25ns, 11 wait states in P:


;------ move the bootstrap loader into FLASH at P:$C000
	move	#botlod,r0		;first DSP address to save
	move	#$C000,r2		;flash starting address
	jsr	WR_FLASH		;save 64 words
        jsr     WR_FLASH                ;and another

        movep  #$0000,x:BCR
        debug
        jmp    *
; that's all folks!

;************************************************************************
;   WR_FLASH
;   This routine writes 64 (24-bit) words from DSP RAM to FLASH EEPROM
; 
;	enter with:   	r2 pointing to starting EEPROM Byte Address
;      			r0 pointing to first DSP word to save
;
;-------------------------------------------------------------------------
;   first, move 64 bytes - this includes 21 words + low byte of 22nd
;-------------------------------------------------------------------------
WR_FLASH
        jsr     disable_protect

        do      #21,move_codeA          ;move 63 bytes
        move    P:(r0)+,A		;get 3 byte word
        move            A1,x:(r2)+	;move low  byte to FLASH EEPROM
        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move mid  byte to FLASH EEPROM
        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move high byte
move_codeA
					;*** 64th byte
        move    P:(r0)+,A		;get next 3 byte word
        move            A1,x:(r2)+      ;move low  byte

        jsr     delay_200u              ;wait 200 microseconds to enter 
                                        ;...program cycle
        jsr     program_complete        ;wait for programming cycle to 
                                        ;...finish
;-------------------------------------------------------------------------
;   then, move another 64 bytes - mid and high bytes of 22nd word followed
;                                 by 20 words and then the low and mid
;				  bytes of the next word
;-------------------------------------------------------------------------
        jsr     disable_protect

        rep     #8			
        lsr     A       
        move            A1,x:(r2)+      ;move mid  byte to FLASH EEPROM
        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move high byte


        do      #20,move_codeB          ;move 60 bytes
        move    P:(r0)+,A		;get 3 byte word
        move            A1,x:(r2)+	;move low  byte to FLASH EEPROM
        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move mid  byte to FLASH EEPROM
        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move high byte
move_codeB
					;*** 63rd byte ***
        move    P:(r0)+,A		;get next 3 byte word
        move            A1,x:(r2)+      ;move low byte
        rep     #8
        lsr     A       		;*** 64th byte ***
        move            A1,x:(r2)+      ;move mid  byte to FLASH EEPROM

        jsr     delay_200u              ;wait 200 microseconds to enter 
                                        ;...program cycle
        jsr     program_complete        ;wait for programming cycle to 




;-------------------------------------------------------------------------
;   lastly, move another 64 bytes - high bytes of last word followed
;                                 by 21 words
;-------------------------------------------------------------------------
        jsr     disable_protect

        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move high byte of last word


        do      #21,move_codeC          ;move 63 bytes
        move    P:(r0)+,A		;get 3 byte word
        move            A1,x:(r2)+	;move low  byte to FLASH EEPROM
        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move mid  byte to FLASH EEPROM
        rep     #8
        lsr     A       
        move            A1,x:(r2)+      ;move high byte
move_codeC

        jsr     delay_200u              ;wait 200 microseconds to enter 
                                        ;...program cycle
        jsr     program_complete        ;wait for programming cycle to 
                                        ;...finish

        jsr     enable_protect
	rts
;***************************************************************************

;----------------------------------------------------------------------------
;  enable_protect - Software data Protection routine
;
;----------------------------------------------------------------------------
enable_protect  
        move    #>$AA,x0
        move            x0,x:$D555   ;Atmel needs $5555
        move    #>$55,x0
        move            x0,x:$AAAA   ;Atmel needs $2AAA
        move    #>$A0,x0
        move            x0,x:$D555   ;writes are now enabled
        rts
           
;---------------------------------------------------------------------------
;  disable_protect - Disables Software Data protection
; 
;  This code writes the appropriate data to the FLASH part that disables
;  the write protection from the FLASH and allows the part to be loaded.
;
;---------------------------------------------------------------------------
disable_protect
        move    #>$AA,x0
        move            x0,x:$D555
        move    #>$55,x0
        move            x0,x:$AAAA
        move    #>$80,x0
        move            x0,x:$D555
        move    #>$AA,x0
        move            x0,x:$D555
        move    #>$55,x0
        move            x0,x:$AAAA
        move    #>$20,x0
        move            x0,x:$D555      ;exit data protect state
        rts

;---------------------------------------------------------------------------
; delay routine to be used to satisfy tBLC time requirement which is
; a minimum of 150 microseconds.
; Write Pulse Width, Write Pulse Width High requires a minimum of
; 3000 Icycles for 40MHz clock.  (50ns/Icycle)
;---------------------------------------------------------------------------
delay_200u  
        rep    #4000      ; delay of 200 micro seconds.
        nop
        rts
   
;---------------------------------------------------------------------------
;  program_complete - routine to poll for the end of the programming cycle
;
;  The AT29C256 will toggle bit 6 on successive reads until the program
;  cycle completes.  When bit 6 stabilizes, the device is no longer in
;  a programming cycle.
;---------------------------------------------------------------------------
program_complete
        btst    #6,x:$8000              ;check the initial status of bit 6
        jcs     check_set
check_clr                               ;---go here if bit 6 is clear---
        jsr     delay_200u              ;no need to hurry, give it a rest
        btst    #6,x:$8000              ;test bit 6...it was clear
        jcs     check_set               ;if it is now set, continue...
        rts
check_set                               ;---go here if bit 6 is set---
        jsr     delay_200u              
        btst    #6,x:$8000              ;test bit 6...it was set
        jcc     check_clr               ;if it is now clear, continue...
        rts

;**************************************************************************
;  this is the bootstrap loader itself
;  it is loaded into the memory at boot time and then moves the
;  application code into DSP RAM from the user serial port
;
; G3PLX EPROM boot program for 56002EVM
; 26/4/97 added send of final byte
; 28/8/97 modified to relocate itself
; 28/10/97 moved to P:$4000; multiple-file load added.
       include  'ioequ.asm'
reloc  equ      $4000
botlod equ      *                                 ;the address in the installer
       org      P:0,P:                            ;runs at P:0, loaded here
       movep    #>$1C0009,X:M_PCTL                ;clkout off, pll on, 40 MHz
       movep    #>$000302,X:M_SCR                 ;8bits async
       movep    #>$000003,X:M_PCC                 ;enable SCI tx, rx
       move     #load,R1                          ;source for move
       move     #reloc,R2                         ;destination for move
       do       #(endtab-reloc),endmov
        move    P:(R1)+,A                         ;do the move
        move    A,P:(R2)+
endmov jmp      reloc

load   equ      *                                 ;the address in the bootstrap
       org      P:reloc,P:                        ;runs at P:reloc
       movep    #>520,X:M_SCCR                    ;652000/1200-1 (1200 baud)
       move     #jtab,N0                          ;set jump table start
       jsr      get2b                             ;get load baudrate
       move     A1,X:M_SCCR                       ;set baudrate
       bset     #4,X:M_SCR                        ;send break to ack
loop   jsr      getb                              ;get section ident byte
       move     A1,R0                             ;move it to address register
       bclr     #4,X:M_SCR                        ;clear break
       move     P:(R0+N0),R0                      ;get jump address from table
       nop
       jsr      (R0)                              ;process section
       jmp      loop                              ;for ever

loadP   jsr     get4b                             ;get address/count
        do       A1,_enddo
         jsr     get3b                            ;get 3byte word
         movem   A1,P:(R0)+                       ;move to P:space
_enddo rts

loadX   jsr     get4b                             ;get address/count
        do       A1,_enddo
         jsr     get3b
         move    A1,X:(R0)+                       ;move to X:space
_enddo rts

loadY   jsr     get4b                             ;get address/count
        do       A1,_enddo
         jsr     get3b
         move    A1,Y:(R0)+                       ;move to Y:space
_enddo rts

loadL   jsr     get4b                             ;get address/count
        do       A1,_enddo
         jsr     get3b                            ;get 3byte word
         move    A1,Y:(R0)                        ;move to Y:space
         jsr     get3b                            ;get 3 more
         move    A1,X:(R0)+                       ;move to X:space
_enddo rts

gogo   jsr      get2b                             ;get entrypoint address
       move     A1,R0                             ;move to address register
       movec    #0,sp                             ;reset stack
       movep    A1,X:M_STXL                       ;send final ack byte
       jclr     #0,X:M_SSR,*                      ;wait for it to be sent
       jmp      (R0)                              ;jump to user prog

again  movec   #0,sp
       jmp      reloc                             ;restart for another load

get4b   jsr     get2b                             ;get 2bytes address
        move     A1,R0                            ;keep it
get2b   jsr      getb                             ;get first one byte
        jmp      get                              ;get another and return

get3b   jsr     get2b                             ;get 2 bytes
        jmp     get                               ;and another and return

getb   clr      A                                 ;get first byte: clear
get    rep      #8                                ;here to ADD a byte
        asl     A                                 ;shift previous byte left
       jclr     #2,X:M_SSR,*                      ;wait for it...
       movep    X:M_SRXL,X1                       ;get it
       or       X1,A                              ;add into lsbyte
       rts

jtab   dc       loadP                             ;jump table
       dc       loadX
       dc       loadY
       dc       loadL
       dc       gogo
       dc       again
endtab
       end      main
