program loadevm1;    {uses mk3 bootstrap  ; with follow-on}
uses crt,evm;
var time,baud,I:word;
    fnames:array[0..9] of string[64];
    Nfiles,N,result:byte;
    go:boolean;
    start:word;

function caps(S:string):string;
var I:integer;
begin
 for I:=1 to length(S) do S[I]:=upcase(S[I]);
 caps:=S
end;

function hexbin(hex:string):word;
var W,I:word;
    B:byte;
begin
 W:=$F000;
 while hex>'' do
 begin
  B:=byte(hex[1]);
  if B>64 then B:=B-7;
  if (B>47) and (B<58) then W:=(W shl 4)+B-48; {add it in if it's hex}
  hex:=copy(hex,2,length(hex))
 end;
 hexbin:=W
end;

procedure doparam(P:byte);
var S:string;
    W:word;
    E:integer;
begin
 S:=caps(paramstr(P));
 if S[1] in ['/','-'] then
 case S[2] of
  'P': setevmport(byte(S[3]) and 15);
  'B': begin
        val(copy(S,3,length(S)),W,E);
        if E=0 then baud:=W
       end;
  'G': begin
        start:=hexbin(copy(S,3,length(S)));
        go:=true
       end;
 end else
 begin
  fnames[Nfiles]:=paramstr(P);
  if pos('.',fnames[Nfiles])=0 then fnames[Nfiles]:=fnames[Nfiles]+'.cld';
  inc(Nfiles)
 end
end;

procedure doparams;
var parmNr:byte;
begin
 for parmNr:=1 to paramcount do doparam(parmNr)
end;

begin
 go:=false;
 Nfiles:=0;
 if paramcount=0 then
 begin
  writeln('LOADEVM [options] <filename> [<filename>...]  [/go]');
  writeln('Filenames default extension .CLD');
  writeln;
  writeln('Commandline options:');
  writeln('/b<baudrate>  : set baudrate, eg /b19200       default 57600');
  writeln('/p<comport>   : set comport,  eg /p2           default COM1');
  writeln('/go[<hex>]    : start EVM at hex address,  eg /g1FFF');
  writeln('/go           : start EVM running at the start address of the last file');
  exit
 end;
 baud:=57600;
 doparams;
 resetEvm;
 for N:=0 to Nfiles-1 do
 begin
  loadEvm(fnames[N],baud);
  result:=EvmResult;
  if result>0 then go:=false;
  writeln(fnames[N],': ',evmmsg(result))
 end;
 if go then
 begin
  if start=$F000 then start:=CLDstart;
  runEvm(start);
  result:=EvmResult;
  if result=0 then writeln('EVM running') else writeln(evmmsg(result))
 end;
 if result>0 then halt(1)
end.